<?php
/**
 * Plugin Name: واتسيرا – إشعارات واتساب
 * Plugin URI: https://watsira.com/woocommerce-notifications
 * Description: إضافة ذكية لربط ووكومرس بواتساب وإرسال إشعارات فورية ومخصّصة لحالات الطلب 📲، لتحسين سرعة التواصل وزيادة رضا العملاء ⭐
 * Version: 1.0.0
 * Author: Watsira
 * Author URI: https://watsira.com
 * License: GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: woocommerce-whatsapp-notifications
 * Domain Path: /languages
 * Requires at least: 5.8
 * Tested up to: 6.7
 * Requires PHP: 7.4
 * WC requires at least: 3.0.0
 * WC tested up to: 9.0.0
 */

/**
 * استبدال "زيارة موقع الإضافة" بـ "دليل التعليمات"
 */
add_filter( 'plugin_row_meta', 'wwnt_replace_plugin_uri_link', 10, 2 );
function wwnt_replace_plugin_uri_link( $links, $plugin_file ) {

    // تأكد أن هذا هو ملف الإضافة الحالية
    if ( $plugin_file === plugin_basename( __FILE__ ) ) {

        foreach ( $links as $key => $link ) {
            if ( strpos( $link, 'watsira.com/woocommerce-notifications' ) !== false ) {
                $links[ $key ] = '<a href="https://watsira.com/woocommerce-notifications/?utm_source=Plugin&utm_medium=Plugin%20Page%20KB%20Link&utm_campaign=WP" target="_blank">دليل التعليمات</a>';
            }
        }
    }

    return $links;
}



// HPOS compatibility
add_action('before_woocommerce_init', function() {
    if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
});

defined('ABSPATH') || exit;

// Define plugin constants
define('WWNT_PLUGIN_FILE', __FILE__);
define('WWNT_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('WWNT_PLUGIN_URL', plugin_dir_url(__FILE__));
define('WWNT_VERSION', '1.0.0');

/**
 * Check if WooCommerce is active
 */
function wwnt_check_woocommerce_active() {
    if (!class_exists('WooCommerce')) {
        add_action('admin_notices', function () {
            echo '<div class="notice notice-error"><p>'
                . esc_html__('WatSira – WooCommerce WhatsApp Notifications requires WooCommerce to be installed and active.', 'woocommerce-whatsapp-notifications')
                . '</p></div>';
        });
        return false;
    }
    return true;
}



// Include required files
require_once WWNT_PLUGIN_PATH . 'includes/class-wwnt-api-handler.php';
require_once WWNT_PLUGIN_PATH . 'includes/class-wwnt-settings.php';
require_once WWNT_PLUGIN_PATH . 'includes/class-wwnt-templates.php';
require_once WWNT_PLUGIN_PATH . 'includes/class-wwnt-notifications.php';

// Initialize the plugin
function wwnt_init() {
    WWNT_Settings::get_instance();
    WWNT_Notifications::get_instance();
}
add_action('plugins_loaded', 'wwnt_init');

// Load text domain
//function wwnt_load_textdomain() {
//    load_plugin_textdomain('woocommerce-whatsapp-notifications', false, dirname(plugin_basename(__FILE__)) . '/languages/');
//}
//add_action('plugins_loaded', 'wwnt_load_textdomain');

// Add field rendering actions
add_action('wwnt_render_enable_field', function($args) {
    $options = get_option('wwnt_settings');
    $status = $args['status'];
    ?>
    <input type="checkbox" name="wwnt_settings[enable_<?php echo esc_attr($status); ?>]" value="1" <?php checked(isset($options['enable_' . $status]) && $options['enable_' . $status]); ?>>
    <label><?php _e('تمكين الأشعارات لهذه الحالة', 'woocommerce-whatsapp-notifications'); ?></label>
    <?php
});

add_action('wwnt_render_recipient_field', function($args) {
    $options = get_option('wwnt_settings');
    $status = $args['status'];
    $recipient = $options['recipient_' . $status] ?? 'customer';
    ?>
    <select name="wwnt_settings[recipient_<?php echo esc_attr($status); ?>]">
        <option value="customer" <?php selected($recipient, 'customer'); ?>><?php _e('المستلم', 'woocommerce-whatsapp-notifications'); ?></option>
        <option value="admin" <?php selected($recipient, 'admin'); ?>><?php _e('المشرف', 'woocommerce-whatsapp-notifications'); ?></option>
        <option value="both" <?php selected($recipient, 'both'); ?>><?php _e('كلاهما', 'woocommerce-whatsapp-notifications'); ?></option>
        <option value="custom" <?php selected($recipient, 'custom'); ?>><?php _e('رقم مخصص', 'woocommerce-whatsapp-notifications'); ?></option>
    </select>
    <input type="text" name="wwnt_settings[custom_recipient_<?php echo esc_attr($status); ?>]" value="<?php echo esc_attr($options['custom_recipient_' . $status] ?? ''); ?>" placeholder="<?php esc_attr_e('ادخل رقم واتساب المخصص بصيغة دولية', 'woocommerce-whatsapp-notifications'); ?>" class="regular-text" style="display: <?php echo $recipient === 'custom' ? 'inline-block' : 'none'; ?>; margin-top: 5px;">
    <p class="description" style="display: <?php echo $recipient === 'custom' ? 'block' : 'none'; ?>;"><?php _e('أدخل رقم واتساب المخصص لاستقبال الإشعارات لهذه الحالة', 'woocommerce-whatsapp-notifications'); ?></p>
    <?php
});

add_action('wwnt_render_template_field', function($args) {
    $options = get_option('wwnt_settings');
    $status = $args['status'];
    $template = $options['template_' . $status] ?? '';
    $placeholders = [

    // — عام (General) —
    '=======  متغيرات عامة =======' => '',
    '{{sitename}}'                  => __('اسم الموقع', 'woocommerce-whatsapp-notifications'),
    '{{siteurl}}'                   => __('رابط الموقع', 'woocommerce-whatsapp-notifications'),
    '{{wordpress-url}}'             => __('رابط ووردبريس', 'woocommerce-whatsapp-notifications'),
    '{{tagline}}'                   => __('الشعار (Tagline)', 'woocommerce-whatsapp-notifications'),
    '{{privacy-policy}}'            => __('رابط سياسة الخصوصية', 'woocommerce-whatsapp-notifications'),

    // — تفاصيل حساب ووردبريس (WordPress Profile Details) —
    '======= متغيرات حساب ووردبريس =======' => '',

    '{{wp-first-name}}'             => __('الاسم الأول', 'woocommerce-whatsapp-notifications'),
    '{{wp-last-name}}'              => __('الاسم الأخير', 'woocommerce-whatsapp-notifications'),
    '{{wp-username}}'               => __('اسم المستخدم', 'woocommerce-whatsapp-notifications'),
    '{{wp-nickname}}'               => __('اللقب', 'woocommerce-whatsapp-notifications'),
    '{{wp-display-name}}'           => __('الاسم الظاهر', 'woocommerce-whatsapp-notifications'),
    '{{wp-email}}'                  => __('البريد الإلكتروني', 'woocommerce-whatsapp-notifications'),
    '{{wp-user-website}}'           => __('موقع المستخدم', 'woocommerce-whatsapp-notifications'),
    '{{wp-user-bio}}'               => __('السيرة الذاتية', 'woocommerce-whatsapp-notifications'),

    // — تفاصيل الطلب في ووكومرس (WooCommerce Order Details) —
    '======= متغيرات تفاصيل الطلب =======' => '',
    '{{wc-order}}'                  => __('رقم الطلب', 'woocommerce-whatsapp-notifications'),
    '{{wc-order-id}}'               => __('معرف الطلب / ID', 'woocommerce-whatsapp-notifications'),
    '{{wc-order-key}}'              => __('مفتاح الطلب (Order Key)', 'woocommerce-whatsapp-notifications'),
    '{{wc-order-status}}'           => __('حالة الطلب', 'woocommerce-whatsapp-notifications'),
    '{{wc-order-date}}'             => __('تاريخ الطلب', 'woocommerce-whatsapp-notifications'),
    '{{wc-product-names}}'          => __('أسماء جميع المنتجات', 'woocommerce-whatsapp-notifications'),
    '{{wc-product-names-br}}'       => __('أسماء جميع المنتجات مع فاصل أسطر', 'woocommerce-whatsapp-notifications'),
    '{{wc-product-names-variable}}' => __('أسماء المنتجات المتغيرة', 'woocommerce-whatsapp-notifications'),
    '{{wc-product-names-variable-br}}' => __('أسماء المنتجات المتغيرة مع فاصل أسطر', 'woocommerce-whatsapp-notifications'),
    '{{wc-product-description}}'    => __('الوصف الكامل للمنتجات', 'woocommerce-whatsapp-notifications'),
    '{{wc-product-excerpt}}'        => __('الوصف المختصر (المقتطف) للمنتجات', 'woocommerce-whatsapp-notifications'),
    '{{wc-product-name-count}}'     => __('أول منتج + عدد العناصر', 'woocommerce-whatsapp-notifications'),
    '{{wc-product-link}}'           => __('روابط المنتجات مفصولة بفواصل', 'woocommerce-whatsapp-notifications'),
    '{{wc-product-link-br}}'        => __('روابط المنتجات مع فاصل أسطر', 'woocommerce-whatsapp-notifications'),
    '{{wc-product-name-link}}'      => __('أسماء المنتجات + روابطها', 'woocommerce-whatsapp-notifications'),
    '{{wc-product-name-link-br}}'   => __('أسماء المنتجات + روابطها مع فاصل أسطر', 'woocommerce-whatsapp-notifications'),
    '{{wc-total-products}}'         => __('إجمالي عدد المنتجات', 'woocommerce-whatsapp-notifications'),
    '{{wc-total-items}}'            => __('إجمالي عدد العناصر', 'woocommerce-whatsapp-notifications'),
    '{{wc-order-items}}'            => __('أسماء المنتجات + عددها', 'woocommerce-whatsapp-notifications'),
    '{{wc-order-items-br}}'         => __('أسماء المنتجات + عددها مع فاصل أسطر', 'woocommerce-whatsapp-notifications'),
    '{{wc-order-items-variable}}'   => __('المنتجات المتغيرة + عددها', 'woocommerce-whatsapp-notifications'),
    '{{wc-order-items-variable-br}}'=> __('المنتجات المتغيرة + عددها مع فاصل أسطر', 'woocommerce-whatsapp-notifications'),
    '{{wc-order-items-price}}'      => __('كل عنصر مع سعره', 'woocommerce-whatsapp-notifications'),
    '{{wc-order-items-price-br}}'   => __('كل عنصر مع سعره وفاصل أسطر', 'woocommerce-whatsapp-notifications'),
    '{{wc-all-order-items-br}}'     => __('جميع عناصر الطلب مع فاصل أسطر', 'woocommerce-whatsapp-notifications'),
    '{{wc-sku}}'                    => __('أكواد SKU للمنتجات', 'woocommerce-whatsapp-notifications'),
    '{{wc-sku-br}}'                 => __('أكواد SKU مع فاصل أسطر', 'woocommerce-whatsapp-notifications'),
    '{{wc-order-amount}}'           => __('المجموع الكلي شامل الضريبة', 'woocommerce-whatsapp-notifications'),
    '{{wc-discount}}'               => __('مجموع الخصومات', 'woocommerce-whatsapp-notifications'),
    '{{wc-tax}}'                    => __('مجموع الضرائب', 'woocommerce-whatsapp-notifications'),
    '{{wc-order-amount-ex-tax}}'    => __('المجموع الكلي بدون الضريبة', 'woocommerce-whatsapp-notifications'),
    '{{wc-payment-method}}'         => __('وسيلة الدفع', 'woocommerce-whatsapp-notifications'),
    '{{wc-transaction-id}}'         => __('رقم معاملة الدفع', 'woocommerce-whatsapp-notifications'),
    '{{wc-shipping-method}}'        => __('وسيلة الشحن', 'woocommerce-whatsapp-notifications'),
    '{{wc-shipping-cost}}'          => __('تكلفة الشحن', 'woocommerce-whatsapp-notifications'),
    '{{wc-refund-amount}}'          => __('المبلغ المسترجع', 'woocommerce-whatsapp-notifications'),
    '{{wc-refund-reason}}'          => __('سبب الاسترجاع', 'woocommerce-whatsapp-notifications'),
    '{{wc-order-notes}}'            => __('ملاحظات الطلب', 'woocommerce-whatsapp-notifications'),

    // — روابط مباشرة للطلب —
    '======= متغيرات الروابط =======' => '',
    '{{wc-order-confirmation-link}}' => __('رابط تأكيد الطلب', 'woocommerce-whatsapp-notifications'),
    '{{wc-order-pay-link}}'          => __('رابط الدفع عند انتظار الدفع', 'woocommerce-whatsapp-notifications'),

    // — تفاصيل الفوترة (WooCommerce Billing Details) —
    '======= متغيرات تفاصيل الفاتورة =======' => '',
    '{{wc-billing-first-name}}'      => __('الاسم الأول للفوترة', 'woocommerce-whatsapp-notifications'),
    '{{wc-billing-last-name}}'       => __('الاسم الأخير للفوترة', 'woocommerce-whatsapp-notifications'),
    '{{wc-billing-company}}'         => __('الشركة', 'woocommerce-whatsapp-notifications'),
    '{{wc-billing-address-line-1}}'  => __('العنوان الأول', 'woocommerce-whatsapp-notifications'),
    '{{wc-billing-address-line-2}}'  => __('العنوان الثاني', 'woocommerce-whatsapp-notifications'),
    '{{wc-billing-city}}'            => __('المدينة', 'woocommerce-whatsapp-notifications'),
    '{{wc-billing-postcode}}'        => __('الرمز البريدي', 'woocommerce-whatsapp-notifications'),
    '{{wc-billing-state}}'           => __('المنطقة / المحافظة', 'woocommerce-whatsapp-notifications'),
    '{{wc-billing-country}}'         => __('الدولة', 'woocommerce-whatsapp-notifications'),
    '{{wc-billing-email}}'           => __('البريد الإلكتروني للفوترة', 'woocommerce-whatsapp-notifications'),
    '{{wc-billing-phone}}'           => __('هاتف الفوترة', 'woocommerce-whatsapp-notifications'),

    // — تفاصيل الشحن (WooCommerce Shipping Details) —
    '======= متغيرات تفاصيل الشحن =======' => '',
    '{{wc-shipping-first-name}}'     => __('الاسم الأول للشحن', 'woocommerce-whatsapp-notifications'),
    '{{wc-shipping-last-name}}'      => __('الاسم الأخير للشحن', 'woocommerce-whatsapp-notifications'),
    '{{wc-shipping-company}}'        => __('الشركة', 'woocommerce-whatsapp-notifications'),
    '{{wc-shipping-address-line-1}}' => __('العنوان الأول للشحن', 'woocommerce-whatsapp-notifications'),
    '{{wc-shipping-address-line-2}}' => __('العنوان الثاني للشحن', 'woocommerce-whatsapp-notifications'),
    '{{wc-shipping-city}}'           => __('المدينة', 'woocommerce-whatsapp-notifications'),
    '{{wc-shipping-postcode}}'       => __('الرمز البريدي', 'woocommerce-whatsapp-notifications'),
    '{{wc-shipping-state}}'          => __('المنطقة / المحافظة', 'woocommerce-whatsapp-notifications'),
    '{{wc-shipping-country}}'        => __('الدولة', 'woocommerce-whatsapp-notifications'),

    // — التنزيلات الرقمية (EDD – Easy Digital Downloads) —
    '======= متغيرات التنزيلات الرقمية =======' => '',
    '{{edd-download_list}}'          => __('قائمة روابط التنزيل للمنتجات الرقمية', 'woocommerce-whatsapp-notifications'),
];

    ?>
    <textarea name="wwnt_settings[template_<?php echo esc_attr($status); ?>]" rows="5" cols="50" class="large-text"><?php echo esc_textarea($template); ?></textarea>
    <p class="description"><?php _e('المتغيرات المتاحة:', 'woocommerce-whatsapp-notifications'); ?></p>
    <ul class="wwnt-placeholders">
        <?php foreach ($placeholders as $placeholder => $description): ?>
            <li><code><?php echo esc_html($placeholder); ?></code> - <?php echo esc_html($description); ?></li>
        <?php endforeach; ?>
    </ul>
    
    
    <?php
});



/**
 * ==============================
 * تفعيل مكتبة intl-tel-input مع جميع التخصيصات
 * ==============================
 */
add_action('wp_enqueue_scripts', 'wwnt_enqueue_phone_field');
function wwnt_enqueue_phone_field() {
    if (!is_checkout()) return;

    // تحميل مكتبة intl-tel-input
    wp_enqueue_script(
        'intl-tel-input',
        'https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js',
        ['jquery'], null, true
    );
    wp_enqueue_style(
        'intl-tel-input-css',
        'https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.min.css'
    );

    // قراءة الدولة الافتراضية من إعدادات الإضافة (افتراضياً السعودية 966)
    $options = get_option('wwnt_settings');
   $default_country_code = $options['default_country_code'] ?? '966';

$inline_js = "
jQuery(document).ready(function($) {
    var input = document.querySelector('#billing_phone');
    if (input) {
        var countryData = window.intlTelInputGlobals.getCountryData();
        var defaultIso2 = 'sa'; // fallback
        
        // البحث عن رمز الدولة من dialCode
        for (var i = 0; i < countryData.length; i++) {
            if (countryData[i].dialCode === '{$default_country_code}') {
                defaultIso2 = countryData[i].iso2;
                break;
            }
        }

        var iti = window.intlTelInput(input, {
            initialCountry: defaultIso2,
            allowDropdown: true,
            separateDialCode: true,
            nationalMode: false,
            formatOnDisplay: true,
            utilsScript: 'https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/utils.js'
        });

        $('form.checkout').on('submit', function(e) {
            if (!iti.isValidNumber()) {
                e.preventDefault();
                e.stopImmediatePropagation();
                input.classList.add('woocommerce-invalid');
                alert('الرجاء إدخال رقم واتساب صالح');
                return false;
            } else {
                input.classList.remove('woocommerce-invalid');
                input.value = iti.getNumber(); // حفظ الرقم بصيغة دولية
            }
        });
    }
});
";
wp_add_inline_script('intl-tel-input', $inline_js);


    // 🔹 جميع تنسيقات CSS مخصصة
    $inline_css = '
/* المكون الرئيسي */
.iti {
    width: 100% !important;
    position: relative;
}

/* padding عند تفعيل القائمة */
.iti--allow-dropdown input {
    padding-left: 65px !important;
}

/* الحقل يغطي كامل العرض */
input[type=tel] {
    width: 100% !important;
}

/* صندوق العلم */
.iti__flag-container {
    background-color: #f1f1f1 !important;
    border: 2px solid #ddd !important;
    border-top-left-radius: 30px !important;
    border-top-right-radius: 0px !important;
    border-bottom-right-radius: 0px !important;
    border-bottom-left-radius: 30px !important;
    padding: 0px !important;
    transition: all 0.2s ease-in-out;
}

/* العلم المحدد */
.iti__selected-flag {
    display: flex !important;
    align-items: center !important;
    gap: 3px !important;
    background: transparent !important;
}

/* القائمة المنسدلة */
.iti__country-list {
    direction: rtl !important;
    text-align: right !important;
    background-color: #fff !important;
    border: 1px solid #ccc !important;
    border-radius: 10px !important;
    width: 300px !important;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    padding: 8px 0 !important;
    overflow-y: auto !important;
    white-space: nowrap !important;
    overflow-x: hidden !important;
    text-overflow: ellipsis !important;
    box-sizing: border-box !important;
    margin: 0 !important;
    z-index: 9999 !important;
}

/* الدولة داخل القائمة */
.iti__country {
    padding: 8px 12px !important;
    margin: 0 !important;
    border-radius: 6px !important;
    display: flex !important;
    justify-content: space-between !important;
    align-items: center !important;
}

/* تمييز الدولة عند المرور */
.iti__country.iti__highlight {
    background-color: #f3f3f3 !important;
}

/* إخفاء المفضل والفاصل */
.iti__preferred,
.iti__divider {
    display: none !important;
}

/* كود الدولة */
.iti__dial-code {
    display: inline-block !important;
    direction: ltr !important;
    color: #444;
    font-size: 14px;
    margin-left: auto !important;
}

/* اسم الدولة */
.iti__country-name {
    font-weight: normal !important;
    max-width: 180px !important;
    overflow: hidden !important;
    text-overflow: ellipsis !important;
    display: inline-block !important;
    vertical-align: middle !important;
    margin-right: 8px;
}

/* شريط التمرير */
.iti__country-list::-webkit-scrollbar {
    width: 8px;
}
.iti__country-list::-webkit-scrollbar-track {
    background: #f5f5f5;
    border-radius: 8px;
}
.iti__country-list::-webkit-scrollbar-thumb {
    background: #bbb;
    border-radius: 8px;
}
.iti__country-list::-webkit-scrollbar-thumb:hover {
    background: #999;
}

#billing_phone {
    direction: ltr !important;        /* اجعل الكتابة من اليسار لليمين */
    text-align: left !important;      /* محاذاة النص للجانب الأيسر */
    padding-left: 100px !important;    /* الهامش الداخلي على اليسار */
    
}

#billing_phone::placeholder {
    direction: rtl !important;        /* placeholder من اليمين لليسار */
    text-align: right !important;     /* محاذاة placeholder إلى اليمين */
}


    ';
    wp_add_inline_style('intl-tel-input-css', $inline_css);
}


/**
 * إضافة زر "إعداد الإشعارات" بجانب (تعطيل | Translate)
 */
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'wwnt_add_settings_link');
function wwnt_add_settings_link($links) {
    // رابط صفحة الإعدادات (تأكد أن slug صحيح)
    $settings_url  = admin_url('admin.php?page=wwnt-settings');
    
    $settings_link = '<a href="' . esc_url($settings_url) . '">' 
        . __('إعداد الإشعارات', 'woocommerce-whatsapp-notifications') 
        . '</a>';

    // يضيف الرابط أول واحد
    array_unshift($links, $settings_link);

    return $links;
}


