<div class="wrap woocommerce">
    <h1><?php esc_html_e('واتسيرا – إشعارات واتساب لووكومرس', 'woocommerce-whatsapp-notifications'); ?></h1>
    
    <?php settings_errors(); ?>
    
    <nav class="nav-tab-wrapper">
        <a href="#general-settings" class="nav-tab nav-tab-active"><?php esc_html_e('إعدادات الربط', 'woocommerce-whatsapp-notifications'); ?></a>
        <a href="#notification-settings" class="nav-tab"><?php esc_html_e('إعدادات الإشعارات', 'woocommerce-whatsapp-notifications'); ?></a>
        <a href="#test-notification" class="nav-tab"><?php esc_html_e('اختبار الإشعارات', 'woocommerce-whatsapp-notifications'); ?></a>
    </nav>
    
    <form method="post" action="options.php">
        <?php settings_fields('wwnt_settings'); ?>
        
        <div id="general-settings" class="wwnt-section">
            <h2><?php esc_html_e('إعدادات الربط', 'woocommerce-whatsapp-notifications'); ?></h2>
            <table class="form-table">
                <?php do_settings_fields('wwnt_settings', 'wwnt_general_section'); ?>
            </table>
        </div>
        
        <div id="notification-settings" class="wwnt-section" style="display:none;">
            <h2><?php esc_html_e('إدارة وتخصيص الإشعارات لكل حالة طلب', 'woocommerce-whatsapp-notifications'); ?></h2>
            <table class="form-table">
                <?php
                $order_statuses = wc_get_order_statuses();
                foreach ($order_statuses as $status => $label) {
                    $status_key = str_replace('wc-', '', $status);
                    ?>
                    <tr valign="top">
                        <th scope="row" colspan="2">
                            <h3 style="margin:0;padding:10px 0;color:#1e1e1e;"><?php echo esc_html($label); ?></h3>
                        </th>
                    </tr>
                    <tr valign="top">
                        <th scope="row"><?php esc_html_e('تفعيل الإشعارات', 'woocommerce-whatsapp-notifications'); ?></th>
                        <td>
                            <?php
                            $field_args = ['status' => $status_key];
                            do_action('wwnt_render_enable_field', $field_args);
                            ?>
                        </td>
                    </tr>
                    <tr valign="top">
                        <th scope="row"><?php esc_html_e('المستلم', 'woocommerce-whatsapp-notifications'); ?></th>
                        <td>
                            <?php do_action('wwnt_render_recipient_field', $field_args); ?>
                        </td>
                    </tr>
                    <tr valign="top">
                        <th scope="row"><?php esc_html_e('نص الأشعار', 'woocommerce-whatsapp-notifications'); ?></th>
                        <td>
                            <?php do_action('wwnt_render_template_field', $field_args); ?>
                        </td>
                    </tr>
                    <?php
                }
                ?>
            </table>
        </div>
        
        <div id="test-notification" class="wwnt-section" style="display:none;">
            <h2><?php esc_html_e('اختبر إشعاراتك قبل إرسالها إلى عملائك', 'woocommerce-whatsapp-notifications'); ?></h2>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row"><?php esc_html_e('رقم واتساب', 'woocommerce-whatsapp-notifications'); ?></th>
                    <td>
                        <input type="text" id="wwnt_test_phone" class="regular-text" placeholder="+1234567890">
                        <p class="description"><?php esc_html_e('الرجاء إدخال رقم واتساب متضمناً رمز الدولة لإرسال رسالة اختبار', 'woocommerce-whatsapp-notifications'); ?></p>
                    </td>
                </tr>
                <tr valign="top">
                    <th scope="row"><?php esc_html_e('نص رسالة الأختبار', 'woocommerce-whatsapp-notifications'); ?></th>
                    <td>
                        <textarea id="wwnt_test_message" rows="5" class="large-text"></textarea>
                        <p><button type="button" id="wwnt_send_test" class="button button-primary"><?php esc_html_e('إرسال الرسالة', 'woocommerce-whatsapp-notifications'); ?></button></p>
                        <div id="wwnt_test_result"></div>
                    </td>
                </tr>
            </table>
        </div>
        
        <?php submit_button(); ?>
    </form>
    
    <div class="wwnt-documentation">
        <h2><?php esc_html_e('الدليل والدعم الفني', 'woocommerce-whatsapp-notifications'); ?></h2>
        <p><?php esc_html_e('لاستخدام الإضافة، يجب أولاً الاشتراك في نظام واتسيرا وربط رقم واتساب الخاص بك. بعد الربط، يمكنك الرجوع إلى إعدادات الإضافة وإدخال بيانات الربط (API/Token) لبدء تخصيص وإرسال الإشعارات تلقائياً.', 'woocommerce-whatsapp-notifications'); ?></p>
        <p><?php esc_html_e('لمعرفة طريقة الاشتراك والربط، شاهد الدليل التعليمي من خلال', 'woocommerce-whatsapp-notifications'); ?> <a href="https://watsira.com/woocommerce-notifications/" target="_blank"><?php esc_html_e('الضغط هنا', 'woocommerce-whatsapp-notifications'); ?></a></p>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    // Tab navigation
    $('.nav-tab-wrapper a').on('click', function(e) {
        e.preventDefault();
        var target = $(this).attr('href');
        
        $('.nav-tab').removeClass('nav-tab-active');
        $(this).addClass('nav-tab-active');
        
        $('.wwnt-section').hide();
        $(target).show();
    });
    
    // Show first tab by default
    $('.nav-tab-wrapper a:first').trigger('click');
    
    // Test notification
    $('#wwnt_send_test').on('click', function() {
        var phone = $('#wwnt_test_phone').val();
        var message = $('#wwnt_test_message').val();
        
        if (!phone || !message) {
            alert('<?php esc_html_e('الرجاء إدخال رقم واتساب ونص الرسالة', 'woocommerce-whatsapp-notifications'); ?>');
            return;
        }
        
        $(this).prop('disabled', true).text('<?php esc_html_e('جارٍ الإرسال...', 'woocommerce-whatsapp-notifications'); ?>');
        $('#wwnt_test_result').html('');
        
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'wwnt_send_test_notification',
                security: '<?php echo wp_create_nonce("wwnt_test_nonce"); ?>',
                phone: phone,
                message: message
            },
            success: function(response) {
                if (response.success) {
                    $('#wwnt_test_result').html('<div class="notice notice-success"><p>' + response.data + '</p></div>');
                } else {
                    $('#wwnt_test_result').html('<div class="notice notice-error"><p>' + response.data + '</p></div>');
                }
            },
            error: function() {
                $('#wwnt_test_result').html('<div class="notice notice-error"><p><?php esc_html_e('حدث خطأ أثناء إرسال رسالة الأختبار', 'woocommerce-whatsapp-notifications'); ?></p></div>');
            },
            complete: function() {
                $('#wwnt_send_test').prop('disabled', false).text('<?php esc_html_e('إرسال رسالة اختبار', 'woocommerce-whatsapp-notifications'); ?>');
            }
        });
    });
    
    // Show/hide custom recipient fields
    $('select[name^="wwnt_settings[recipient_"]').each(function() {
        toggleCustomRecipientField($(this));
    });

    $("body").on("change", 'select[name^="wwnt_settings[recipient_"]', function() {
        toggleCustomRecipientField($(this));
    });

    function toggleCustomRecipientField(select) {
        var status = select.attr("name").match(/recipient_(.*?)]/)[1];
        var customField = $('input[name="wwnt_settings[custom_recipient_' + status + ']"]');
        var parentTd = select.closest('td');

        if (select.val() === "custom") {
            customField.show();
            parentTd.find('.description').show();
        } else {
            customField.hide();
            parentTd.find('.description').hide();
        }
    }
});
</script>
