<?php
if (!defined('ABSPATH')) exit;

class WWNT_Templates {
    private static $instance = null;

    private function __construct() {
        // Add default templates if they don't exist
        add_action('admin_init', [$this, 'set_default_templates']);
    }

    public static function get_instance() {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function set_default_templates() {
        $settings = get_option('wwnt_settings');
        
        if (empty($settings)) {
            $settings = [];
        }
        
        $order_statuses = wc_get_order_statuses();
        foreach ($order_statuses as $status => $label) {
            $status_key = str_replace('wc-', '', $status);
            
            if (!isset($settings['template_' . $status_key])) {
                $settings['template_' . $status_key] = $this->get_default_template($status_key);
            }
        }
        
        update_option('wwnt_settings', $settings);
    }

    private function get_default_template($status) {
        $shop_name = get_bloginfo('name');
        
        switch ($status) {
            case 'processing':
                return sprintf(__("مرحباً {{customer_name}},\n\nتم استلام طلبك رقم {{order_id}} وهو الآن قيد المعالجة.\n\nالإجمالي: {{order_total}}\n\nشكراً لتسوقك من %s!", 'woocommerce-whatsapp-notifications'), $shop_name);
            
            case 'completed':
                return sprintf(__("مرحباً {{customer_name}},\n\nتم إكمال طلبك رقم {{order_id}} وسيصلك قريباً.\n\nالإجمالي: {{order_total}}\n\nشكراً لتسوقك من %s!", 'woocommerce-whatsapp-notifications'), $shop_name);
            
            case 'on-hold':
                return sprintf(__("مرحباً {{customer_name}},\n\nطلبك رقم {{order_id}} حالياً قيد الانتظار.\n\nسنقوم بإشعارك عند معالجته.\n\nالإجمالي: {{order_total}}\n\n%s", 'woocommerce-whatsapp-notifications'), $shop_name);
            
            case 'cancelled':
                return sprintf(__("مرحباً {{customer_name}},\n\nتم إلغاء طلبك رقم {{order_id}}.\n\nإذا كان هذا خطأ، يرجى التواصل معنا.\n\n%s", 'woocommerce-whatsapp-notifications'), $shop_name);
            
            case 'refunded':
                return sprintf(__("مرحباً {{customer_name}},\n\nتم رد المبلغ لطلبك رقم {{order_id}}.\n\nإذا كانت لديك أي استفسارات، يرجى التواصل معنا.\n\n%s", 'woocommerce-whatsapp-notifications'), $shop_name);
            
            case 'failed':
                return sprintf(__("مرحباً {{customer_name}},\n\nفشل الدفع لطلبك رقم {{order_id}}.\n\nيرجى التحقق من وسيلة الدفع والمحاولة مرة أخرى.\n\n%s", 'woocommerce-whatsapp-notifications'), $shop_name);
            
            default:
                return sprintf(__("مرحباً {{customer_name}},\n\nتم تغيير حالة طلبك رقم {{order_id}} إلى {{order_status}}.\n\nالإجمالي: {{order_total}}\n\n%s", 'woocommerce-whatsapp-notifications'), $shop_name);
        }
    }
}
