<?php
if (!defined('ABSPATH')) exit;

class WWNT_Settings {
    private static $instance = null;

    private function __construct() {
        add_action('admin_menu', [$this, 'add_admin_menu']);
        add_action('admin_init', [$this, 'settings_init']);
        add_action('admin_enqueue_scripts', [$this, 'enqueue_admin_assets']);
    }

    public static function get_instance() {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    public function enqueue_admin_assets($hook) {
        if ('woocommerce_page_wwnt-settings' !== $hook) {
            return;
        }

        wp_enqueue_style('wwnt-admin-css', WWNT_PLUGIN_URL . 'assets/css/admin.css', [], WWNT_VERSION);
        wp_enqueue_script('wwnt-admin-js', WWNT_PLUGIN_URL . 'assets/js/admin.js', ['jquery'], WWNT_VERSION, true);
    }

    public function add_admin_menu() {
        add_submenu_page(
            'woocommerce',
            __('واتسيرا - إشعارات واتساب', 'woocommerce-whatsapp-notifications'),
            __('واتسيرا - إشعارات واتساب', 'woocommerce-whatsapp-notifications'),
            'manage_woocommerce',
            'wwnt-settings',
            [$this, 'settings_page']
        );
    }

    public function settings_page() {
        include WWNT_PLUGIN_PATH . 'templates/admin/settings-page.php';
    }

    public function settings_init() {
       register_setting(
    'wwnt_settings',
    'wwnt_settings',
    array(
        'sanitize_callback' => array($this, 'sanitize_settings')
    )

);


        // General Settings Section
        add_settings_section(
            'wwnt_general_section',
            __('إعدادات عامة', 'woocommerce-whatsapp-notifications'),
            [$this, 'general_section_callback'],
            'wwnt_settings'
        );

        add_settings_field('api_type', __('نوع الربط', 'woocommerce-whatsapp-notifications'), [$this, 'api_type_render'], 'wwnt_settings', 'wwnt_general_section');
        //add_settings_field('api_url', __('رابط الـ API', 'woocommerce-whatsapp-notifications'), [$this, 'api_url_render'], 'wwnt_settings', 'wwnt_general_section');
        add_settings_field('token', __('مفتاح API الخاص بك', 'woocommerce-whatsapp-notifications'), [$this, 'token_render'], 'wwnt_settings', 'wwnt_general_section');
        add_settings_field('from_number', __('رقم الإرسال (مع رمز الدولة)', 'woocommerce-whatsapp-notifications'), [$this, 'from_number_render'], 'wwnt_settings', 'wwnt_general_section');
        add_settings_field('admin_phone', __('رقم واتساب المشرف', 'woocommerce-whatsapp-notifications'), [$this, 'admin_phone_render'], 'wwnt_settings', 'wwnt_general_section');
        add_settings_field(
    'default_country_code',
    __('رمز الدولة الافتراضي', 'woocommerce-whatsapp-notifications'),
    [$this, 'default_country_code_render'],
    'wwnt_settings',
    'wwnt_general_section'
);


        // Notification Settings Section
        add_settings_section(
            'wwnt_notification_section',
            __('إعدادات الإشعارات', 'woocommerce-whatsapp-notifications'),
            [$this, 'notification_section_callback'],
            'wwnt_settings'
        );

        $order_statuses = wc_get_order_statuses();
        foreach ($order_statuses as $status => $label) {
            $status_key = str_replace('wc-', '', $status);
            
            add_settings_field(
                'enable_' . $status_key,
                sprintf(__('تفعيل الإشعارات لـ %s', 'woocommerce-whatsapp-notifications'), $label),
                [$this, 'enable_status_render'],
                'wwnt_settings',
                'wwnt_notification_section',
                ['status' => $status_key]
            );

            add_settings_field(
                'recipient_' . $status_key,
                sprintf(__('المستلم لـ %s', 'woocommerce-whatsapp-notifications'), $label),
                [$this, 'recipient_render'],
                'wwnt_settings',
                'wwnt_notification_section',
                ['status' => $status_key]
            );

            add_settings_field(
                'template_' . $status_key,
                sprintf(__('قالب الرسالة لـ %s', 'woocommerce-whatsapp-notifications'), $label),
                [$this, 'template_render'],
                'wwnt_settings',
                'wwnt_notification_section',
                ['status' => $status_key]
            );
        }

        // Test Notification Section
        add_settings_section(
            'wwnt_test_section',
            __('اختبار الإشعارات', 'woocommerce-whatsapp-notifications'),
            [$this, 'test_section_callback'],
            'wwnt_settings'
        );

        add_settings_field('test_phone', __('رقم واتساب للاختبار', 'woocommerce-whatsapp-notifications'), [$this, 'test_phone_render'], 'wwnt_settings', 'wwnt_test_section');
        add_settings_field('test_message', __('رسالة تجريبية', 'woocommerce-whatsapp-notifications'), [$this, 'test_message_render'], 'wwnt_settings', 'wwnt_test_section');
    }
public function api_type_render() {
    ?>
    <input type="hidden" name="wwnt_settings[api_type]" value="qr">
    <p class="description"><?php _e('النظام يعمل فقط على كيو ار واتساب (QR WhatsApp API)', 'woocommerce-whatsapp-notifications'); ?></p>
    <?php
}

    public function general_section_callback() {
        echo '<p>' . __('قم بإعداد بيانات اتصال واجهة واتساب API', 'woocommerce-whatsapp-notifications') . '</p>';
    }

    public function notification_section_callback() {
        echo '<p>' . __('حدد حالات الطلب التي يجب أن ترسل إشعارات واتساب عند حدوثها', 'woocommerce-whatsapp-notifications') . '</p>';
    }

    public function test_section_callback() {
        echo '<p>' . __('أرسل إشعاراً تجريبياً للتأكد من إعداداتك', 'woocommerce-whatsapp-notifications') . '</p>';
    }

    public function api_url_render() {
        $options = get_option('wwnt_settings');
        $api_type = $options['api_type'] ?? 'qr';
        ?>
        <input type="url" name="wwnt_settings[api_url]" value="<?php echo esc_url($options['api_url'] ?? ''); ?>" class="regular-text">
        <p class="description">
            <?php if ($api_type === 'qr'): ?>
                <?php _e('رابط API الخاص بالـ QR (مثال: https://b.watsira.com/api/qr)', 'woocommerce-whatsapp-notifications'); ?>
            <?php else: ?>
                <?php _e('رابط API ميتا (مثال: https://b.watsira.com/api/v1/send-message)', 'woocommerce-whatsapp-notifications'); ?>
            <?php endif; ?>
        </p>
        <?php
    }

    public function token_render() {
        $options = get_option('wwnt_settings'); 
        ?>
        <input type="password" name="wwnt_settings[token]" value="<?php echo esc_attr($options['token'] ?? ''); ?>" class="regular-text">
        <p class="description"><?php _e('مفتاح الوصول للمصادقة', 'woocommerce-whatsapp-notifications'); ?></p>
        <?php
    }

    public function from_number_render() {
        $options = get_option('wwnt_settings');
        ?>
        <input type="text" name="wwnt_settings[from_number]" value="<?php echo esc_attr($options['from_number'] ?? ''); ?>" class="regular-text">
        <p class="description"><?php _e('رقم واتساب الذي سترسل منه الرسائل (مع رمز الدولة، مثال: +1234567890)', 'woocommerce-whatsapp-notifications'); ?></p>
        <?php
    }

    public function admin_phone_render() {
        $options = get_option('wwnt_settings');
        ?>
        <input type="text" name="wwnt_settings[admin_phone]" value="<?php echo esc_attr($options['admin_phone'] ?? ''); ?>" class="regular-text">
        <p class="description"><?php _e('رقم واتساب المشرف لاستقبال الإشعارات (مع رمز الدولة)', 'woocommerce-whatsapp-notifications'); ?></p>
        <?php
    }
    
    public function default_country_code_render() {
    $options = get_option('wwnt_settings');
    ?>
    <input type="text" name="wwnt_settings[default_country_code]" 
           value="<?php echo esc_attr($options['default_country_code'] ?? '966'); ?>" 
           class="regular-text" placeholder="مثال: 966">
    <p class="description"><?php _e('أدخل رمز الدولة الافتراضي بدون + (مثال: 966 للسعودية)', 'woocommerce-whatsapp-notifications'); ?></p>
    <?php
}


    public function enable_status_render($args) {
        $options = get_option('wwnt_settings');
        $status = $args['status'];
        ?>
        <input type="checkbox" name="wwnt_settings[enable_<?php echo esc_attr($status); ?>]" value="1" <?php checked(isset($options['enable_' . $status]) && $options['enable_' . $status]); ?>>
        <label><?php _e('تفعيل الإشعارات لهذه الحالة', 'woocommerce-whatsapp-notifications'); ?></label>
        <?php
    }

    public function recipient_render($args) {
        $options = get_option('wwnt_settings');
        $status = $args['status'];
        $recipient = $options['recipient_' . $status] ?? 'customer';
        ?>
        <select name="wwnt_settings[recipient_<?php echo esc_attr($status); ?>]">
            <option value="customer" <?php selected($recipient, 'customer'); ?>><?php _e('العميل', 'woocommerce-whatsapp-notifications'); ?></option>
            <option value="admin" <?php selected($recipient, 'admin'); ?>><?php _e('المشرف', 'woocommerce-whatsapp-notifications'); ?></option>
            <option value="both" <?php selected($recipient, 'both'); ?>><?php _e('كلاهما', 'woocommerce-whatsapp-notifications'); ?></option>
            <option value="custom" <?php selected($recipient, 'custom'); ?>><?php _e('رقم مخصص', 'woocommerce-whatsapp-notifications'); ?></option>
        </select>
        <input type="text" name="wwnt_settings[custom_recipient_<?php echo esc_attr($status); ?>]" value="<?php echo esc_attr($options['custom_recipient_' . $status] ?? ''); ?>" placeholder="<?php esc_attr_e('أدخل رقم واتساب المخصص', 'woocommerce-whatsapp-notifications'); ?>" class="regular-text">
        <?php
    }

    public function template_render($args) {
        $options = get_option('wwnt_settings');
        $status = $args['status'];
        $template = $options['template_' . $status] ?? '';
        $placeholders = [

    // — تفاصيل الطلب (Order Information) —
    '— تفاصيل الطلب —'                 => '======= تفاصيل الطلب =======',
    '{{order_id}}'                      => __('رقم الطلب', 'woocommerce-whatsapp-notifications'),
    '{{order_number}}'                  => __('الرقم الظاهر للطلب', 'woocommerce-whatsapp-notifications'),
    '{{order_name}}'                    => __('أسماء المنتجات في الطلب', 'woocommerce-whatsapp-notifications'),
    '{{order_qty}}'                     => __('إجمالي عدد العناصر', 'woocommerce-whatsapp-notifications'),
    '{{order_items}}'                   => __('قائمة المنتجات مع الكمية', 'woocommerce-whatsapp-notifications'),
    '{{order_items_with_price}}'        => __('قائمة المنتجات مع الكمية والسعر', 'woocommerce-whatsapp-notifications'),
    '{{order_subtotal}}'                => __('المجموع الفرعي قبل الضريبة والشحن', 'woocommerce-whatsapp-notifications'),
    '{{order_tax}}'                     => __('إجمالي قيمة الضريبة', 'woocommerce-whatsapp-notifications'),
    '{{order_shipping}}'                => __('تكلفة الشحن', 'woocommerce-whatsapp-notifications'),
    '{{order_discount}}'                => __('مبلغ الخصم', 'woocommerce-whatsapp-notifications'),
    '{{order_coupon}}'                  => __('رمز الكوبون المستخدم', 'woocommerce-whatsapp-notifications'),
    '{{order_note}}'                    => __('ملاحظة العميل على الطلب', 'woocommerce-whatsapp-notifications'),
    '{{order_status}}'                  => __('حالة الطلب', 'woocommerce-whatsapp-notifications'),
    '{{order_total}}'                   => __('الإجمالي الكلي للطلب', 'woocommerce-whatsapp-notifications'),
    '{{order_date}}'                    => __('تاريخ الطلب', 'woocommerce-whatsapp-notifications'),
    '{{order_date_completed}}'          => __('تاريخ إكمال الطلب', 'woocommerce-whatsapp-notifications'),
    '{{order_date_paid}}'               => __('تاريخ دفع الطلب', 'woocommerce-whatsapp-notifications'),

    // — بيانات العميل (Customer Information) —
    '— بيانات العميل —'                 => '======= بيانات العميل =======',
    '{{customer_name}}'                 => __('اسم العميل الكامل', 'woocommerce-whatsapp-notifications'),
    '{{customer_first_name}}'           => __('الاسم الأول للعميل', 'woocommerce-whatsapp-notifications'),
    '{{customer_last_name}}'            => __('الاسم الأخير للعميل', 'woocommerce-whatsapp-notifications'),
    '{{customer_email}}'                => __('بريد العميل الإلكتروني', 'woocommerce-whatsapp-notifications'),
    '{{customer_phone}}'                => __('هاتف العميل', 'woocommerce-whatsapp-notifications'),
    '{{customer_id}}'                   => __('معرّف المستخدم للعميل', 'woocommerce-whatsapp-notifications'),
    '{{customer_username}}'             => __('اسم المستخدم للعميل', 'woocommerce-whatsapp-notifications'),

    // — عناوين الفوترة والشحن (Addresses) —
    '— عناوين الفوترة والشحن —'          => '======= عناوين الفوترة والشحن =======',
    '{{billing_address}}'               => __('عنوان الفوترة', 'woocommerce-whatsapp-notifications'),
    '{{shipping_address}}'              => __('عنوان الشحن', 'woocommerce-whatsapp-notifications'),
    '{{billing_company}}'               => __('شركة الفوترة', 'woocommerce-whatsapp-notifications'),
    '{{shipping_company}}'              => __('شركة الشحن', 'woocommerce-whatsapp-notifications'),
    '{{billing_city}}'                  => __('مدينة الفوترة', 'woocommerce-whatsapp-notifications'),
    '{{shipping_city}}'                 => __('مدينة الشحن', 'woocommerce-whatsapp-notifications'),
    '{{billing_state}}'                 => __('منطقة الفوترة', 'woocommerce-whatsapp-notifications'),
    '{{shipping_state}}'                => __('منطقة الشحن', 'woocommerce-whatsapp-notifications'),
    '{{billing_postcode}}'              => __('الرمز البريدي للفوترة', 'woocommerce-whatsapp-notifications'),
    '{{shipping_postcode}}'             => __('الرمز البريدي للشحن', 'woocommerce-whatsapp-notifications'),
    '{{billing_country}}'               => __('دولة الفوترة', 'woocommerce-whatsapp-notifications'),
    '{{shipping_country}}'              => __('دولة الشحن', 'woocommerce-whatsapp-notifications'),

    // — تفاصيل المنتجات (Products Information) —
    '— تفاصيل المنتجات —'               => '======= تفاصيل المنتجات =======',
    '{{first_product_name}}'            => __('اسم أول منتج', 'woocommerce-whatsapp-notifications'),
    '{{first_product_qty}}'             => __('كمية أول منتج', 'woocommerce-whatsapp-notifications'),
    '{{product_categories}}'            => __('تصنيفات المنتجات في الطلب', 'woocommerce-whatsapp-notifications'),

    // — طرق الدفع والشحن (Payment / Shipping Methods) —
    '— طرق الدفع والشحن —'              => '======= طرق الدفع والشحن =======',
    '{{payment_method}}'                => __('طريقة الدفع', 'woocommerce-whatsapp-notifications'),
    '{{shipping_method}}'               => __('طريقة الشحن', 'woocommerce-whatsapp-notifications'),

    // — تتبع الشحنة (Tracking) —
    '— تتبع الشحنة —'                   => '======= تتبع الشحنة =======',
    '{{tracking_number}}'               => __('رقم تتبع الشحنة', 'woocommerce-whatsapp-notifications'),
    '{{tracking_url}}'                  => __('رابط تتبع الشحنة', 'woocommerce-whatsapp-notifications'),

    // — معلومات المتجر (Shop Information) —
    '— معلومات المتجر —'                => '======= معلومات المتجر =======',
    '{{shop_name}}'                     => __('اسم المتجر', 'woocommerce-whatsapp-notifications'),
    '{{shop_url}}'                      => __('رابط المتجر', 'woocommerce-whatsapp-notifications'),
    '{{shop_email}}'                    => __('البريد الإلكتروني للمتجر', 'woocommerce-whatsapp-notifications'),
    '{{shop_phone}}'                    => __('هاتف المتجر', 'woocommerce-whatsapp-notifications'),
    '{{shop_address}}'                  => __('العنوان الفعلي للمتجر', 'woocommerce-whatsapp-notifications'),
];

        ?>
        <textarea name="wwnt_settings[template_<?php echo esc_attr($status); ?>]" rows="5" cols="50" class="large-text"><?php echo esc_textarea($template); ?></textarea>
        <p class="description"><?php _e('المتغيرات المتاحة:', 'woocommerce-whatsapp-notifications'); ?></p>
        <ul class="wwnt-placeholders">
            <?php foreach ($placeholders as $placeholder => $description): ?>
                <li><code><?php echo esc_html($placeholder); ?></code> - <?php echo esc_html($description); ?></li>
            <?php endforeach; ?>
        </ul>
        <?php
    }

    public function test_phone_render() {
        ?>
        <input type="text" id="wwnt_test_phone" class="regular-text" placeholder="+1234567890">
        <p class="description"><?php _e('أدخل رقم واتساب مع رمز الدولة لإرسال رسالة أختبار', 'woocommerce-whatsapp-notifications'); ?></p>
        <?php
    }

    public function test_message_render() {
        ?>
        <textarea id="wwnt_test_message" rows="5" cols="50" class="large-text"></textarea>
        <p><button type="button" id="wwnt_send_test" class="button button-primary"><?php _e('إرسال رسالة تجريبية', 'woocommerce-whatsapp-notifications'); ?></button></p>
        <div id="wwnt_test_result"></div>
        <?php
    }
    
        /**
     * Sanitize all settings before saving to database
     */
public function sanitize_settings($input) {
    $output = [];

    if (!is_array($input)) {
        return [];
    }

    foreach ($input as $key => $value) {

        // ✅ قوالب الرسائل فقط (متعددة الأسطر)
        if (strpos($key, 'template_') === 0) {

            // نحافظ على الأسطر
            $value = (string) $value;
            $value = str_replace(["\r\n", "\r"], "\n", $value);

            // تنظيف خفيف بدون كسر \n
           $value = wp_unslash($value);
           $value = str_replace(["\r\n", "\r"], "\n", $value);


            $output[$key] = $value;

        } else {

            // ✅ باقي الإعدادات
            if (is_array($value)) {
                $output[$key] = array_map('sanitize_text_field', $value);
            } else {
                $output[$key] = sanitize_text_field($value);
            }
        }
    }

    return $output;
}


}
