jQuery(document).ready(function ($) {
  // تبديل الحقول بناءً على نوع الـ API
  function toggleApiFields() {
    var apiType = $("#wwnt_api_type").val();
    var apiUrlField = $('input[name="wwnt_settings[api_url]"]');
    var apiUrlDescription = apiUrlField.closest("tr").find(".description");

    if (apiType === "meta") {
      // إخفاء حقل "من الرقم" لـ Meta API
      $('input[name="wwnt_settings[from_number]"]').closest("tr").hide();

      // تحديث وصف رابط الـ API
      apiUrlDescription.html(
        "رابط Meta API (مثال: http://localhost:3000/api/v1/send-message)"
      );

      // إذا كان الحقل فارغ اقترح مثال Meta API
      if (apiUrlField.val() === "") {
        apiUrlField.val("http://localhost:3000/api/v1/send-message");
      }
    } else {
      // إظهار حقل "من الرقم" لـ QR API
      $('input[name="wwnt_settings[from_number]"]').closest("tr").show();

      // تحديث وصف رابط الـ API
      apiUrlDescription.html("رابط QR API (مثال: https://yourdomain.com/api/qr)");

      // إذا كان الحقل يحتوي مثال Meta → امسحه
      if (apiUrlField.val() === "http://localhost:3000/api/v1/send-message") {
        apiUrlField.val("");
      }
    }
  }

  // تشغيل عند تحميل الصفحة
  toggleApiFields();

  // تبديل عند تغيير نوع الـ API
  $("#wwnt_api_type").on("change", toggleApiFields);

  // تشغيل إخفاء/إظهار الحقول للمستلمين المخصصين
  $('select[name^="wwnt_settings[recipient_"]').each(function () {
    toggleCustomRecipientField($(this));
  });

  $("body").on(
    "change",
    'select[name^="wwnt_settings[recipient_"]',
    function () {
      toggleCustomRecipientField($(this));
    }
  );

  function toggleCustomRecipientField(select) {
    var status = select.attr("name").match(/recipient_(.*?)]/)[1];
    var customField = $(
      'input[name="wwnt_settings[custom_recipient_' + status + ']"]'
    );
    var parentTd = select.closest("td");

    if (select.val() === "custom") {
      customField.show();
      parentTd.find(".description").show();
    } else {
      customField.hide();
      parentTd.find(".description").hide();
    }
  }

  // إظهار/إخفاء المتغيرات (Placeholders)
  $(".wwnt-placeholders").each(function () {
    var placeholderList = $(this);
    placeholderList.hide();

    var toggleLink = $(
      '<a href="#" class="wwnt-toggle-placeholders">عرض المتغيرات المتاحة</a>'
    );
    toggleLink.insertBefore(placeholderList);

    toggleLink.on("click", function (e) {
      e.preventDefault();
      placeholderList.toggle();
      $(this).text(
        placeholderList.is(":visible")
          ? "إخفاء المتغيرات المتاحة"
          : "عرض المتغيرات المتاحة"
      );
    });
  });
});
